#pragma once
#define EXTDATA_LEN 4096
#include "ThreadBase.h"
class CUSBModule : public CThreadBase
{
public:
	CUSBModule(IMsgListener *pListener);
	virtual ~CUSBModule();
	void HeartBeat_Imp();
	void DealOneRequestMsg(CInterProtocl *pITP);
	void DealOneResponseMsg(CInterProtocl *pITP);
public:
	IMsgListener *m_pListener;
private:    //Serial Port
	int MData_chksum(unsigned char*p, int len);
	char Header_chksum( char *p);
	int RS_SendDataPack(HANDLE hCom, char *buf, int size);
	void ChangeDataToASCII(char*Sbuf,int Size, char*Destbuf,int Flag);
	BOOL WriteCommBlock( HANDLE hCom,  char *buf, unsigned int size);
	int ReadCommBlock(HANDLE hCom, char *buf, unsigned int size);
	char* SinkDataFromCom(void);
	void CloseCOM();
	
	//void SaveData( CString &str, char *data = NULL, int len = 0);
	void SaveData( char *str, char *data = NULL, int len = 0);
private:     //USB Port

private:     //
	int SendCommand(int Command,int Param,int Size, char Flag, char* databuf,int datalen);
	char* WaitACKData(int timeout);
	void DealSuccessFlag(PRSHeader header);
	void DealFailureFlag(PRSHeader header);
	void AnalysisBuffer(char *buf);
	char* SinkExtData(int& SinkLen,int& Param ,int flag,int type);
	int SendExtData(char* SendBuffer, int SendLen,int Command);
public:
	void ConnectToModule(CInterProtocl *pReq, CInterProtocl *pRes);
	void DisConnectToModule(CInterProtocl *pReq, CInterProtocl *pRes);

	void Enroll(CInterProtocl *pReq, CInterProtocl *pRes);
	void EnrollImage(CInterProtocl *pReq, CInterProtocl *pRes);

	void ScanFpImage(CInterProtocl *pReq, CInterProtocl *pRes);

	void Verify(CInterProtocl *pReq, CInterProtocl *pRes);

	void DelTmp(CInterProtocl *pReq, CInterProtocl *pRes);
	void DelDB(CInterProtocl *pReq, CInterProtocl *pRes);

	void LoadLog(CInterProtocl *pReq, CInterProtocl *pRes);
	void DelLog(CInterProtocl *pReq, CInterProtocl *pRes);

	void GetTime(CInterProtocl *pReq, CInterProtocl *pRes);
	void SetTime(CInterProtocl *pReq, CInterProtocl *pRes);

	void ReadParam(CInterProtocl *pReq, CInterProtocl *pRes);
	void WriteParam(CInterProtocl *pReq, CInterProtocl *pRes);
	void SaveParam(CInterProtocl *pReq, CInterProtocl *pRes);

	void DelUser(CInterProtocl *pReq, CInterProtocl *pRes);
	void AddUser(CInterProtocl *pReq, CInterProtocl *pRes);
	void ReadUser(CInterProtocl *pReq, CInterProtocl *pRes);
	void LoadUser(CInterProtocl *pReq, CInterProtocl *pRes);

	void EnrollTmp(CInterProtocl *pReq, CInterProtocl *pRes);
	void ReadTmp(CInterProtocl *pReq, CInterProtocl *pRes);
	void LoadTmp(CInterProtocl *pReq, CInterProtocl *pRes);

	void Updata(CInterProtocl *pReq, CInterProtocl *pRes);
	void Reset(CInterProtocl *pReq, CInterProtocl *pRes);
	void ScanTmp(CInterProtocl *pReq, CInterProtocl *pRes);

	void StartReadData();
	void ReadData(CInterProtocl *pReq, CInterProtocl *pRes);
	void StopReadData();
private:
	int connectSerial();
	int connectUSB();
private:
	void *m_sensor;    //USB Port
private:
	HANDLE m_hCom;
	int m_ComBaudRate;
	int m_ComNum;
	int m_ModuleState;
	int m_ConnectOK;
	//char m_ComOutBuf[8*1024];
	//char m_ComInBuf[8*1024];
	char m_ComOutBuf[200*1024];
	char m_ComInBuf[200*1024];
	TOptions m_Options;
	OVERLAPPED m_Write_OS;
	OVERLAPPED m_READ_OS;  
	int m_Readlen;
	unsigned int m_BlockTransport;
	int m_connectType;
	int m_StartRead;
	int m_SinkDataLen;
};